## Themes and Memes

- [https://x.com/RylanSchaeffer/status/1702346986329108703?s=20](https://x.com/RylanSchaeffer/status/1702346986329108703?s=20 "https://x.com/RylanSchaeffer/status/1702346986329108703?s=20")
	- this is a reference to [the debate over the unreleased Phi-1 model](https://twitter.com/suchenzang/status/1702004679222378751) which stands accused of contamination on the GSM8K benchmarks
- the new operating systems
  - https://twitter.com/karpathy/status/1707437820045062561
    - https://twitter.com/swyx/status/1707530994797220215
  - windows
  - ios
  - browsers
  - cloud
- controlnet image generation theme
  - Spirals: [http://spirals.vercel.app](https://t.co/jj2FoloLJV)
  - illusion diffusion https://twitter.com/stuffyokodraws/status/1705364938896847120 https://www.fal.ai/models/illusion-diffusion https://huggingface.co/spaces/AP123/IllusionDiffusion
	  - (masterpiece:1.4), (best quality), (detailed), Illustrate a world where islands float mysteriously in the sky, connected by improbable bridges. 
		  - (worst quality, poor details:1.4), lowres, (artist name, signature, watermark:1.4), bad-artist-anime, bad_prompt_version2, bad-hands-5, ng_deepnegative_v1_75t
	  - "Japanese illustration on parchment, with waves, castles and rocks"
	  - "futuristic cityscape on alien planet with starry night sky" ‍ ‍ ‍ ‍ ‍ ‍ ‍ ‍ ‍ ‍ ‍ ‍ ‍ ‍ ‍
	  - "1970s street view photograph of london"
	  - "painting of medieval castle on a hill"
	  - https://dragganaitool.com/best-illusiondiffusion-ai-prompts/
  - "cute cats" and OBEY memes https://twitter.com/whatafunnymeme/status/1705064043893907458
- alternative silicon
  - amd [AMD adoption](https://twitter.com/realSharonZhou/status/1706701693684154766)
  - amazon trainium - anthropic
- "agi has been achieved internally"
  - willdepu paperlips
  - ai breakdown on "trolling everyone"

## OpenAI and Google news

- gemini vs multimodal GPT4 https://www.theinformation.com/articles/openai-hustles-to-beat-google-to-launch-multimodal-llm?rc=1tesbi
- google bard integration
  - https://www.nytimes.com/2023/09/19/technology/google-bard-ai-chatbot-youtube-gmail.html
  - https://www.nytimes.com/2023/09/20/technology/google-bard-extensions.html
  - can be used to search email https://twitter.com/maccaw/status/1735393296946545001?s=12&t=90xQ8sGy63D2OtiaoGJuww
- lots of demos of Dalle3
	- text generation is solved! - you can say "[a wide angle photo of a television, a CNN banner reports “Breaking news: We are not alone”](https://twitter.com/fofrAI/status/1708193403882594741)" and it works
	- [mario on couch](https://twitter.com/skirano/status/1707868051612328383)
	- [passes the muffins in oven talking test](https://twitter.com/fofrAI/status/1707879381450760318)
	- can [generate its own text in the image that fits the prompt but not explicitly asked for](https://twitter.com/multimodalart/status/1708011429268214087)
	- can make a ridiculously good [Batman strip](https://x.com/ammaar/status/1707975011049635983?s=20) ( [some tips](https://x.com/ammaar/status/1708023645778640931?s=20) )
	- rollout in bing was strange - some noting it [felt like "DallE 2.9"](https://twitter.com/fofrAI/status/1707821645895733598) because it didnt quite match up to DallE 3. [still exhibits homonym duplication and failed attribute binding](https://twitter.com/RoyiRassin/status/1708177634390135112).
- gpt4 vision - [credit of the openai team - Raul Puri](https://x.com/TheRealRPuri/status/1706468384454697409?s=20)
  - https://x.com/DrJimFan/status/1706337077892440307?s=20
  - bemyeyes assistant https://news.ycombinator.com/item?id=37673300
  - [Great documentation of abilities and limitations from Roboflow](https://news.ycombinator.com/item?id=37673409)
  - Coding
	  - [SaaS dashboard screen](https://twitter.com/mckaywrigley/status/1707047423863136687)
	  - [frontend engineer agent](https://x.com/gdb/status/1707822777506431345?s=20) and [iteratively designs webapps](https://twitter.com/mattshumer_/status/1707480439793840402)
	  - [whiteboard -> software](https://twitter.com/mckaywrigley/status/1707101465922453701)
	  - [figma to code](https://twitter.com/GabGarrett/status/1706872805214593173)
  - (correctly) [identifies The Dress as blue and black](https://x.com/Teknium1/status/1707516580048068727?s=20)
  - [solves problems from a photo of an electrial engineering textbook](https://x.com/skirano/status/1707468861929381959?s=20)
  - [food pics to recipes](https://x.com/gdb/status/1708194916415726063?s=20) 
  - [finding Waldo](https://x.com/gdb/status/1707603038561526158?s=20)
  - [explaining cell diagrams](https://twitter.com/mckaywrigley/status/1707408491110080602)
  - [explaining parking](https://twitter.com/petergyang/status/1707169696049668472)
  - [meme analysis](https://twitter.com/skirano/status/1706874309124194707)
  - [understands the diagram for the Inception movie without direct reference](https://x.com/mckaywrigley/status/1708153813583204394?s=20)
  - 160 page analysis of the capabilities https://arxiv.org/pdf/2309.17421.pdf 
- Chatgpt voice
	- https://x.com/gdb/status/1707950260843073853?s=20
	- [talking to itself](https://twitter.com/gopatrik/status/1707107901603713462)
- https://cookbook.openai.com/
	- https://x.com/simonpfish/status/1705255275488551213?s=20
- gpt4 vision
	- https://x.com/DrJimFan/status/1706337077892440307?s=20
	- bemyeyes assistant rollout https://news.ycombinator.com/item?id=37673300
	- https://twitter.com/mckaywrigley/status/1707047423863136687
	- the dress https://x.com/Teknium1/status/1707516580048068727?s=20
	- first impressions roboflow https://news.ycombinator.com/item?id=37673409
- chatgpt browsing
  - https://x.com/openai/status/1707077710047216095?s=46
- devday link https://www.youtube.com/watch?v=U9mJuUkhUzk
- "[ChatGPT September 25 Version](https://help.openai.com/en/articles/6825453-chatgpt-release-notes)"
  - My knowledge is current up to January 2022.
  - [July jailbreaks](https://twitter.com/swyx/status/1682095347303346177/photo/2) no [longer work](https://chat.openai.com/share/f5e369b1-483d-4703-aeb6-b39b49fdbda0)
- openai phone - jony ive
- usage breakdown https://twitter.com/OfficialLoganK/status/1707804564810797256/photo/1
- [openai onesided referral plan added](https://twitter.com/frantzfries/status/1708278551928004679)

## Models

- [Falcon 180B](https://news.ycombinator.com/item?id=37404424#37409823) - [TIIUAE post](https://falconllm.tii.ae/falcon.html). [Weirdly low code dataset percentage](https://x.com/DrJimFan/status/1699459647592403236?s=20).
- Adept Persimmon-8B - [unusual tokenizer choice for multimodality](https://twitter.com/suchenzang/status/1699926154298482837)
- [Open Hermes 13B on Llama-2](https://twitter.com/Teknium1/status/1699887247196348676) trained on 242,000 entries of primarily GPT-4 generated data, from open datasets across the AI landscape, including: GPTeacher, WizardLM, Airoboros, Camel-AI's domain experts, CodeAlpaca, GPT4-LLM and Unnatural Instructions
- [Llama-2 Yarn 128k 13b](https://twitter.com/nisten/status/1697437294934802859) and [Long Llama 2 70B on par with GPT4 for summarization](https://x.com/_philschmid/status/1708042427276087698?s=20)
- [Stable Audio: Fast Timing-Conditioned Latent Audio Diffusion](https://stability.ai/research/stable-audio-efficient-timing-latent-diffusion) ([stability.ai](https://news.ycombinator.com/from?site=stability.ai))
- ASR - Nvidia FastConformer and [Open-ASR leaderboard](https://huggingface.co/spaces/hf-audio/open_asr_leaderboard)
- mistral 7b https://news.ycombinator.com/item?id=37675496
  - https://twitter.com/MistralAI/status/1706877320844509405
  - [trained on data from 2023](https://twitter.com/abacaj/status/1707841413910495608)
  - [minimal safety tuning](https://twitter.com/paul_rottger/status/1707430998600831424?s=20) but it is more helpful as a result (passes the "[kill a linux process](https://x.com/AravSrinivas/status/1707988903788187850?s=20)" test that Llama2 failed)
- [NexusRaven-13B](https://twitter.com/NexusflowX/status/1707470614012035561), a new SOTA OSS LLM for function calling. Matches GPT-3.5 in zero-shot
- [DeciLM-6B](https://twitter.com/akshay_pachaar/status/1701946197051940927) - "15x faster inference than Llama2 7b (while matching benchmarks)" with their Infery SDK 

## Misc Papers and Good Reads

- [Recursively summarizing enables long-term dialogue memory in LLMs](https://arxiv.org/abs/2308.15022): We prompt an arbitrary large language model to play two roles, i.e. memory management and response generator. The former is responsible for recursively summarizing the key information along with long-term dialogue, and the latter is to incorporate the memory to generate an appropriate response.
- [Instruction Tuning for Large Language Models: A Survey](https://arxiv.org/abs/2308.10792) Covers both the creation and usage of instruction-datasets for LLM finetuning.
- QA LORA paper https://twitter.com/rasbt/status/1708097036501860655
- [Evaluation & Hallucination Detection for Abstractive Summaries](https://eugeneyan.com/writing/abstractive/): good literature review blogpost on the major techniques for abstractive summarization
- [More on Mixture of Experts models](https://finbarrtimbers.substack.com/p/more-on-mixture-of-experts-models) ([tweet recap](https://twitter.com/finbarrtimbers/status/1700547119957029216)) good lit review on MoE - selection of 6 papers - RL routing, Non-parametric hash layers, BASE, Differentiable Select-K, Expert choice routing, Soft MoE
- Wired magazine coverage of OpenAI has an exclusive email interview with Alec Radford. [my comments.](https://twitter.com/swyx/status/1699369076529971545)
- [Asking 60+ LLMs a set of 20 questions](https://benchmarks.llmonitor.com/) a set of informal benchmarks on a bunch of open source models. More interesting that people care about relatable benchmarks vs HellaSwag
- [LLMs, RAG, & the missing storage layer for AI](https://blog.lancedb.com/llms-rag-the-missing-storage-layer-for-ai-28ded35fa984) - LanceDB making an argument for RAG vs finetuning and multimodality
- [Squish Meets Structure: Designing with Language Models](https://twitter.com/Mappletons/status/1700182898639306884) some AI UX thinking from Maggie Appleton of Elicit.org
- [Large Language Models as Optimizers](https://arxiv.org/pdf/2309.03409.pdf)  found that "Take a deep breath and work on this problem step by step" on PaLM 2 offered 8 points of improvement over "Let's think step by step"
- Expressive Text-to-Image Generation with Rich Text [https://rich-text-to-image.github.io](https://t.co/fXjXiBP3eC) https://huggingface.co/spaces/songweig/rich-text-to-image
- ["Reversal Curse" paper](https://owainevans.github.io/reversal_curse.pdf) ([tweet thread](https://twitter.com/goodside/status/1705452625838149823)) - LLMs trained on “A is B” fail to learn “B is A”
	- but... is it real? [a response from Andrew Mayne](https://andrewmayne.com/2023/11/14/is-the-reversal-curse-real/)
- [Compositional Foundation Models for Hierarchical Planning](https://twitter.com/du_yilun/status/1703786005612929214) for multimodal FMs 
- [PyTorch visualization of Mmult and Attention](https://pytorch.org/blog/inside-the-matrix/)
- Nice flowchart on RAG vs Finetuning ![https://pbs.twimg.com/media/F5g4PxqXMAA16mP?format=jpg&name=large](https://pbs.twimg.com/media/F5g4PxqXMAA16mP?format=jpg&name=large) via [Jerry Liu](https://twitter.com/jerryjliu0/status/1700170811783471350/photo/1)
- Sequoia updated market map https://www.sequoiacap.com/article/generative-ai-act-two/
  - https://www.sequoiacap.com/article/follow-the-gpus-perspective/
- LM Braswell KPCB https://leighmariebraswell.substack.com/p/how-to-make-history-with-llms-and
- [Now is the time for grimoires](https://www.oneusefulthing.org/p/now-is-the-time-for-grimoires) - Ethan Mollick talking about building a spellbook of prompts

## Fundraises and Milestones

- AI grant 2 https://twitter.com/danielgross/status/1699537311384699247
- Imbue fka Generally Intelligent $200M series B [tweet](https://twitter.com/kanjun/status/1699794157945208918?s=20), [forbes profile](https://www.forbes.com/sites/alexkonrad/2023/09/07/ai-research-lab-imbue-nabs-200-million-for-speculative-bet-to-build-ai-agents/?sh=7903e5d2b1ee)
- databricks [series I](https://x.com/databricks/status/1702313344206528819?s=20)
- [patronus AI ](https://x.com/whoisnnamdi/status/1702358163092316610?s=20)
- anthropic 4b from amazon
- [Character AI raising at $5b](# Character.AI in Early Talks for Funding at More Than $5 Billion Valuation)
- writer 100m fundraise https://techcrunch.com/2023/09/18/writer-nets-100m-for-its-enterprise-focused-generative-ai-platform/ - jasper ceo step down

## AI Eng Tooling

- [LangChain Hub](https://twitter.com/LangChainAI/status/1699095883512778823) ([blog](https://blog.langchain.dev/langchain-prompt-hub/)) - prompt publishing, discovery, sharing
- [Ironclad Rivet](https://rivet.ironcladapp.com/) ([tweet](https://twitter.com/gogwilt/status/1700130166343713031)) - Open-Source Visual AI Programming Environment
- [DSPy](https://news.ycombinator.com/item?id=37417698) - we covered this last month, but seems to have done its HN launch this month. lots of discussion and confusion over what exactly it does for automatic prompt engineering. DSPy is built on DSP - A paper is [forthcoming](https://news.ycombinator.com/item?id=37423746) ([released in Oct](https://twitter.com/_akhaliq/status/1710105224843501937), with a [llamaindex webinar](https://twitter.com/llama_index/status/1711062276382539912?s=12&t=90xQ8sGy63D2OtiaoGJuww))
- [Lantern](https://news.ycombinator.com/item?id=37499375) is a PostgreSQL vector database extension for building AI applications. match or outperform pgvector and pg_embedding (Neon) on CREATE INDEX time, SELECT throughput, and SELECT latency.
- [ZodGPT](https://github.com/dzhng/zod-gpt) - Get structured, fully typed, and validated JSON outputs from OpenAI and Anthropic models. A library for
	-   Receiving structured outputs from models with complete type safety. All responses are fully validated & typed, works with [zod](https://github.com/colinhacks/zod) as a peer dep.
	-   Schema definition, serialization / parsing, and **automatically asking the model to correct outputs**.
	-   Handle rate limit and any other API errors as gracefully as possible (e.g. exponential backoff for rate-limit) via [llm-api](https://github.com/dzhng/llm-api).


## RAG Corner

- [Building RAG-based LLM Applications for Production (Part 1)](https://www.anyscale.com/blog/a-comprehensive-guide-for-building-rag-based-llm-applications-part-1) full guide from Anyscale

## Agents Corner

- [The Rise and Potential of Large Language Model Based Agents: A Survey](https://arxiv.org/abs/2309.07864) co-written by people from [Genshin Impact](https://twitter.com/DrJimFan/status/1704140230914388480)
- [AutoGen: Enabling Next-Gen LLM Applications via Multi-Agent Conversation Framework](https://arxiv.org/abs/2308.08155)- a MetaGPT like framework from Microsoft. some excitement from [the Youtubers](https://youtu.be/zdcCD--IieY?si=6S08VikHScoSjbKR)
- [The State of AI Agents](https://e2b.dev/blog/the-state-of-ai-agents-reliability-sdks-benchmarking-and-market-trends)
	- AI agents possess three main capabilities.
		1.  They **combine reasoning and acting**. The agent uses LLMs like GPT-3.5 and GPT-4 to understand, execute, and reflect on tasks.
		2.  They have **both short and long-term memory**.
		3.  Agents can use "**tools" by calling external APIs** - for example, it can browse the web, use apps, read and write files, make payments, and even control a user's laptop.
	- Agents switch from a standalone product to an “invisible” feature
	- Agents still have a long way to enterprise-level reliability
	- Agents are in need of specific SDKs and frameworks
	- The community is looking for standards for autonomous agents
	- with some nice maps and charts of the Agents landscape
- [Cognitive Architectures for LLM Agents](https://twitter.com/johnjnay/status/1700939153565737444)
	- We propose Cognitive Architectures for Language Agents (CoALA). CoALA describes a language agent with modular memory components, a structured action space to interact with internal memory and external environments, and a generalized decision-making process to choose actions

## Open Source Projects and templates

- [Open Interpreter](https://twitter.com/hellokillian/status/1699156860073640038) an open-source Code Interpreter that runs locally.
- Vercel v0.dev ([tweet](https://twitter.com/jaredpalmer/status/1702356555218506070), [intro video](https://twitter.com/shadcn/status/1702390674216329469)) - [examples](https://v0.dev/t/4AsVwNf) - AI tool that is effectively Midjourney for React. With v0 you can use simple prompts to generate copy-and-paste friendly React , powered by @shadcn UI and Tailwind CSS.
  - [open source alternative](https://x.com/n_raidenai/status/1704226792985309198?s=20)
- Vercel v0.dev ([tweet](https://twitter.com/jaredpalmer/status/1702356555218506070)) - [examples](https://v0.dev/t/4AsVwNf) - AI tool that is effectively Midjourney for React. With v0 you can use simple prompts to generate copy-and-paste friendly React , powered by @shadcn UI and Tailwind CSS.
	- [open source alternative aka openv0](https://x.com/n_raidenai/status/1704226792985309198?s=20), [rapidpages](https://github.com/rapidpages/rapidpages)
	- https://x.com/shadcn/status/1708341248342573201?s=20
- [Whisper Turbo](https://twitter.com/swyxio/status/1701973576444768324): Engineered from scratch in Rust + WebGPU. Transcribe 20x faster than realtime - all in the browser!
- [OpenAI Finetuning Model Creator](https://github.com/theindiehacker/openai-finetuning-model-creator)
- [WhatsApp-Llama: A clone of yourself from your WhatsApp conversations](https://github.com/Ads-cmu/WhatsApp-Llama) - good example code of a simple finetune you can do altho results not great yet. However TIL Meta has a llama-recipes repo.
- [SECInsights.ai](https://twitter.com/jerryjliu0/status/1699119197190775084) - open sourced official LlamaIndex full demo app including intermediate steps, granular highlights, streaming support
- [OnPrem.LLM](https://amaiya.github.io/onprem/) A tool for running large language models on-premises using non-public data
- [QrGPT](https://twitter.com/nutlope/status/1705309659307868613) - generate beautiful QR Codes with AI in 1 click.
- Ollama Linux showhn knowcked down https://news.ycombinator.com/item?id=37661755
  - https://llm-tracker.info/books/llms/page/openai-api-compatibility
- Autogen https://microsoft.github.io/autogen/
- [Instagraph from Yohei](https://twitter.com/yoheinakajima/status/1701738098755768538) - Converts text or URL into a visualized knowledge graph.
- [TinyLlama](https://github.com/jzhang38/TinyLlama) - an open endeavor to pretrain a 1.1B Llama model on 3 trillion tokens.
- [ChatGPT History Export to MD](https://news.ycombinator.com/item?id=37636701) - nice tool to export your own ChatGPT convos

## other notable launches

- Canva Chatgpt Plugin got some excitement  https://twitter.com/itsPaulAi/status/1698339560013594843
- perplexity mobile apps https://twitter.com/AravSrinivas/status/1707442190216266176
- glaive code arena https://x.com/abacaj/status/1704956542242447376?s=20
- [Replit ModelFarm](https://twitter.com/Replit/status/1701993771465052666) - built in Replit AI library that implements an API for text completion, chat completion, and text embeddings, and supports streaming
- [Show HN: HackYourNews – AI summaries of the top HN stories](https://hackyournews.com/)
- magentic vs marvin https://news.ycombinator.com/item?id=37661767
- cloudflare workers ai https://news.ycombinator.com/item?id=37674097
- rift 2.1 https://twitter.com/morph_labs/status/1705227786187628737
- [Doodly](https://twitter.com/RisingSayak/status/1700163109363859720) - scribble and generate art from it using language guidance using SDXL and T2I adapters
- bedrock GA - pricing comparison https://twitter.com/_philschmid/status/1707689463084621880?s=20
- braintrust data https://x.com/alanaagoyal/status/1707434633833701783?s=20
- fill3d https://news.ycombinator.com/item?id=37695530 function https://www.fill3d.ai/
- [OpenInterpreter running falcon 180B offline](https://twitter.com/hellokillian/status/1700886834111537473)
- Perplexity [Mobile App](https://x.com/perplexity_ai/status/1707441648395776336?s=20) and [Collections](https://twitter.com/AravSrinivas/status/1702379272986566808)
- [Microsoft unveils unified Copilot that extends across Bing, Edge, and Windows](https://www.windowscentral.com/microsoft/microsoft-unveils-unified-copilot-that-extends-across-bing-edge-and-windows)

## Useful learning

- [The math behind Attention Mechanisms](https://www.youtube.com/watch?v=UPtG_38Oq8o) - math behind the Keys, Queries, and Values matrices, in a friendly pictorial way using diagrams and linear transformations
- [Can LLMs learn from a single example?](https://www.fast.ai/posts/2023-09-04-learning-jumps/) - Jeremy Howard's discovery on rapid memorization in finetuning/training.
- [A Hacker's Guide to Language Models](https://twitter.com/jeremyphoward/status/1705883362991472984?s=20) - Jeremy Howard's 90min complete overview of LLM learnings - starting at the basics: the 3-step pre-training / fine-tuning / classifier ULMFiT approach used in all modern LLMs.
- [GPT2 Perplexity visualizer by Linus Lee](https://twitter.com/thesephist/status/1699190649096933474)
- Evolution of [GGML -> GGUF spec](https://github.com/philpax/ggml/blob/gguf-spec/docs/gguf.md#historical-state-of-affairs)
- [new Jay Alammar video on Tokenizers](https://www.youtube.com/watch?v=rT6wVLEDC_w)
- agents overview via autogpt arena event https://lablab.ai/event/autogpt-arena-hacks, https://m.twitch.tv/lablabai

## Misc

- Safety
  - https://x.com/Altimor/status/1705115106244506092?s=20
  - [Alignment Workshop talks were released](https://twitter.com/RichardMCNgo/status/1697657007858389186), including talks from Ilya Sutskever, Ajeya Cotra, and Dan Hendrycks.
- Security
- OpenAI [disputed the Sarah Silverman lawsuit](https://arstechnica.com/tech-policy/2023/08/openai-disputes-authors-claims-that-every-chatgpt-response-is-a-derivative-work/)
- Prior discussions
  - [Explaining grokking through circuit efficiency](https://arxiv.org/abs/2309.02390)
  - [AMD adoption](https://twitter.com/realSharonZhou/status/1706701693684154766)
  - Dario Amodei [getting some credit for doubling down on scaling](https://twitter.com/sherjilozair/status/1694498972209955222), and DeepSpeech 2 team being a "mafia".
	  - [Chinchilla's Death](Chinchilla’s Death) got some [good discussion](https://news.ycombinator.com/item?id=37383413). The [TinyLlama](https://github.com/jzhang38/TinyLlama) project is going to test that limit with a 3000:1 data to params ratio, and Emad Mostaque has also [announced](https://twitter.com/EMostaque/status/1707894440583442827) StableLM-3b-4e1t which is a 3b model trained on [1T tokens](https://stability.wandb.io/stability-llm/stable-lm/reports/StableLM-3B-4E1T--VmlldzoyMjU4?accessToken=u3zujipenkx5g7rtcj9qojjgxpconyjktjkli2po09nffrffdhhchq045vp0wyfo) for 4 epochs (333:1).
  - More custom instructions from [Matt Shumer - building in chain of thought](https://twitter.com/mattshumer_/status/1700169043406123294) and [legal document explainers](https://twitter.com/mattshumer_/status/1702039776772202963) and [Ethan Mollick - editing memory.txt and ideas.txt](https://twitter.com/emollick/status/1705422957856604503)
  - Emergence - [just in-context learning](https://twitter.com/_aidan_clark_/status/1700666102500725235?s=20)?
- Time Magazine AI list honored [gdb](https://time.com/collection/time100-ai/6309033/greg-brockman/) but [missed Karpathy, Sutskever, Mostaque, Ng](https://twitter.com/chheplo/status/1699766659060568487) 
- rich sutton joins keen technologies https://www.youtube.com/watch?v=aM7F5kuMjRA
- FaceSwap
  - [FaceFusion 1.1.0 face swapping on CPU](https://twitter.com/henryruhs/status/1699362697941254629)
- [Osmo smelling model](https://x.com/DrJimFan/status/1701716520496214272?s=20)
- GPUs
	- coreweave tier 1 https://x.com/suchenzang/status/1708209407979589998?s=20
- Citogenesis
  - https://twitter.com/gaganghotra_/status/1706545667362210129
  - on hn [https://news.ycombinator.com/item?id=37658319](https://news.ycombinator.com/item?id=37658319 "https://news.ycombinator.com/item?id=37658319")
- [tesla optimus](https://x.com/DrJimFan/status/1707812100943524220?s=20)
- [karpathy coined hallucinations](https://twitter.com/DrJimFan/status/1703072983903060260)
	- [disputed](https://news.ycombinator.com/item?id=37775313)
